<?php
// Always call session_start() at the very beginning of the script
session_start();

// Read the raw POST data from the input stream
$json_data = file_get_contents('php://input');

// Decode the JSON data into a PHP associative array
$data = json_decode($json_data, true);

if (isset($data['userId'], $data['userName'], $data['theme'])) {
    // Sanitize and validate the data before storing it (important for security)
    $_SESSION['user_id'] = filter_var($data['userId'], FILTER_SANITIZE_NUMBER_INT);
    $_SESSION['user_name'] = filter_var($data['userName'], FILTER_SANITIZE_STRING);
    $_SESSION['user_theme'] = filter_var($data['theme'], FILTER_SANITIZE_STRING);

    // Send a JSON response back to JavaScript
    echo json_encode(['message' => 'Session variables updated successfully!']);
    
} else {
    echo json_encode(['message' => 'Error: Missing data']);
}
?>
